"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var timers_exports = {};
__export(timers_exports, {
  Timers: () => Timers
});
module.exports = __toCommonJS(timers_exports);
class Timers {
  timeouts = [];
  intervals = [];
  rafs = [];
  /** @public */
  setTimeout(handler, timeout, ...args) {
    const id = window.setTimeout(handler, timeout, args);
    this.timeouts.push(id);
    return id;
  }
  /** @public */
  setInterval(handler, timeout, ...args) {
    const id = window.setInterval(handler, timeout, args);
    this.intervals.push(id);
    return id;
  }
  /** @public */
  requestAnimationFrame(callback) {
    const id = window.requestAnimationFrame(callback);
    this.rafs.push(id);
    return id;
  }
  /** @public */
  dispose() {
    this.timeouts.forEach((id) => clearTimeout(id));
    this.intervals.forEach((id) => clearInterval(id));
    this.rafs.forEach((id) => cancelAnimationFrame(id));
    this.timeouts.length = 0;
    this.intervals.length = 0;
    this.rafs.length = 0;
  }
}
//# sourceMappingURL=timers.js.map
